<?php

// Don't allow to access to this plugin directly
if (!defined('ABSPATH')) {
   exit;
}

/**
 * Add actions links
 *
 * @param array $actions
 * @return array
 */
function toman_escrow_add_action_links(array $actions): array {
   $myLinks = [
      '<a href="' . admin_url( 'admin.php?page=wc-settings&tab=checkout&section=wc_toman_safe_pay' ) . '">'. __('Settings', 'toman-escrow-for-woocommerce') . '</a>',
   ];

   return array_merge($actions, $myLinks);
}
add_filter( 'plugin_action_links_' . TOMAN_ESCROW_PLUGIN_FILE_BASENAME, 'toman_escrow_add_action_links' );
