<?php

// Require plugins.php file to deactive this plugin if WooCommerce is not activated
require_once(ABSPATH . 'wp-admin/includes/plugin.php');

// Don't allow to access to this plugin directly
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Check plugin activation requirements
 *
 * @return void
 */
function toman_escrow_check_plugin_can_activate()
{
    // Check if WooCommerce plugin is not activated, deactive this plugin
    if (is_admin() && current_user_can('activate_plugins') && !is_plugin_active('woocommerce/woocommerce.php')) {// phpcs:ignore
        // Show error notice
        add_action('admin_notices', 'toman_escrow_show_plugin_needs_woocommerce_admin_notice');

        // Deactive this plugin
        deactivate_plugins(plugin_basename(__FILE__));
        if (isset($_GET['activate'])) {// phpcs:ignore
            unset($_GET['activate']);// phpcs:ignore
        }

        return;
    }
}

/**
 * If WooCommerce is not installed, we show this admin notice when activating Toman Escrow plugin
 *
 * @return void
 */
function toman_escrow_show_plugin_needs_woocommerce_admin_notice()
{
    ?>
    <div class="alert alert-danger notice is-dismissible">
        <p>
            <?php
            echo wp_kses( __("Error! You have to install WooCommerce first", 'toman-escrow-for-woocommerce') , array());
            ?>
        </p>
    </div>
    <?php
}
