<?php

/**
 * Send shipment information to Toman API
 *
 * @return void
 */
function toman_escrow_shipment_submit_form()
{
    check_admin_referer('submit-shipment-order' . $_POST['id']);
    $params = array(
        "status" => "error"
    );
    if (!isset($_POST['type']) || !isset($_POST['id']) || !isset($_POST['leadtime'])) {
        wp_redirect(admin_url('admin.php?page=toman-escrow-orders'));
        exit;
    }

    $order = wc_get_order($_POST['id']);
    if (!$order || $order->get_payment_method() != "WC_Toman_Safe_Pay" || !in_array($order->get_status(), array("on-hold", "processing"))) {
        wp_redirect(get_shipment_url($params, $_POST['id']));
        exit;
    }

    $traceNumber = $order->get_meta('toman_escrow_trace_number', true);
    if ($traceNumber == "") {
        wp_redirect(get_shipment_url($params, $_POST['id']));
        exit;
    }

    // Prepare request
    $tomanGateway = (new WC_Toman_Safe_Pay());
    $url = TOMAN_ESCROW_API_BASE_URL . '/users/me/shops/' . $tomanGateway->shopSlug . '/deals/' . $traceNumber . '/shipments-shop';
    $body = [
        'type' => $_POST['type'],
        'inquiry_code' => $_POST['inquiry'],
        'description' => $_POST['description'],
    ];

    // Send request
    $response = wp_remote_post($url, [
        'body' => wp_json_encode($body),
        'headers' => $h = [
            'Authorization' => $tomanGateway->get_toman_api_authorization_token(),
            'Plugin-Version' => TOMAN_PLUGIN_VERSION,
            'Content-Type' => 'application/json',
            'Accept' => 'application/json',
            'Accept-Language' => 'fa',
        ],
        'sslverify' => false
    ]);

    // If response is fault, show error
    if (is_wp_error($response) || (wp_remote_retrieve_response_code($response) != 200 && wp_remote_retrieve_response_code($response) != 409)) {
        $params["message"] = __("There is an error in submitting your request", 'toman-escrow-for-woocommerce');
        wp_redirect(get_shipment_url($params, $_POST['id']));
        exit;
    }

    $url = TOMAN_ESCROW_API_BASE_URL . '/users/me/shops/' . $tomanGateway->shopSlug . '/deals/' . $traceNumber . '/ship-shops';
    $body = [
        'lead_time' => "{$_POST['leadtime']} 00:00:00"
    ];

    // Send request
    $response = wp_remote_request($url, [
        'method' => 'PATCH',
        'body' => wp_json_encode($body),
        'headers' => [
            'Authorization' => $tomanGateway->get_toman_api_authorization_token(),
            'Plugin-Version' => TOMAN_PLUGIN_VERSION,
            'Content-Type' => 'application/json',
            'Accept' => 'application/json',
            'Accept-Language' => 'fa',
        ],
        'sslverify' => false
    ]);

    // If response is fault, show error
    if (is_wp_error($response)) {
        $params["message"] = __("There is an error in submitting your request", 'toman-escrow-for-woocommerce');
        wp_redirect(get_shipment_url($params, $_POST['id']));
        exit;
    } elseif (wp_remote_retrieve_response_code($response) != 204) {
        $res = json_decode($response['body']);
        if (is_object($res) && isset($res->detail)) {
            $message = $res->detail;
        } else {
            $message = __("There is an error in submitting your request", 'toman-escrow-for-woocommerce');
        }
        $params["message"] = $message;
        wp_redirect(get_shipment_url($params, $_POST['id']));
        exit;
    }
    wp_redirect(admin_url('admin.php?page=toman-escrow-orders'));
    exit;
}

add_action('admin_post_toman_escrow_shipment_form_action', 'toman_escrow_shipment_submit_form');
add_action('admin_post_nopriv_toman_escrow_shipment_form_action', 'toman_escrow_shipment_submit_form');
