<?php
/*
 * Plugin Name: TomanPay Escrow Service for WooCommerce
 * Plugin URI: https://tomanpay.net
 * Description: TomanPay Escrow Service for WooCommerce. You can trade safely now
 * Author: Toman
 * Author URI: https://tomanpay.net/
 * Version: 1.2.1
 * Text Domain: toman-escrow-for-woocommerce
 * Domain Path: /languages
 */


// Don't allow to access to this plugin directly
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin direction
define('TOMAN_ESCROW_PLUGIN_DIR', plugin_dir_path(__FILE__));

// Init Persian translation
require_once(plugin_dir_path(__FILE__) . 'init-persian-translation.php');

// Load constants
require_once(plugin_dir_path(__FILE__) . 'includes/constants.php');

// Load actions links
require_once(plugin_dir_path(__FILE__) . 'actions-links.php');

// Load Toman Escrow payment gateway
require_once(plugin_dir_path(__FILE__) . 'includes/payment-gateway-for-woocommerce/main.php');
require_once(plugin_dir_path(__FILE__) . 'includes/payment-gateway-for-woocommerce/utilities.php');

// Load admin dashboard
require_once(plugin_dir_path(__FILE__) . 'includes/payment-gateway-for-woocommerce/admin.php');

// Load shipment form
require_once(plugin_dir_path(__FILE__) . 'includes/shipment-form/form-handler.php');
